@extends('layouts.master')

@section('title')
    تقرير تقييمات المتدربين للدورة التدريبية
@endsection

@section('first-css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/charts.css/dist/charts.min.css">
@endsection

@section('content-body')
    <!--**********************************
                                        Content body start
                                    ***********************************-->
    @include('massages')
@section('route-path')
    <div class="container-fluid container-fluid-traning px-0">
        <div class="d-flex flex-wrap align-items-end justify-content-between  mb-3">
            <h3>
                تقرير تقييمات المتدربين  للدورة 
                @isset($room)
                {{$room->name}} 
                @endisset 
            </h3>
            <div class="link">
                <a href="" class="px-4 ">عرض تقرير تقييمات المتدربين
                </a>
            </div>
        </div>
    </div>
@endsection
<!-- row -->

<div class="container-fluid container-fluid-traning bg-white">
    <!--**********************************Tabs Start***********************************-->

    <!--**********************************Tabs End***********************************-->
    <!--**********************************Table AllTransaction Start***********************************-->

    @isset($evaluations)
        @foreach ($evaluations as $evaluation)
            @if ($evaluation->type == 0)
                @include('reports.tabels.evaluation-table')
            @else
                @include('reports.tabels.evaluation-text-table')
            @endif
        @endforeach
    @endisset
    <!--**********************************Table AllTransaction End***********************************-->


    <div class="code-example">
        <style name="datasets-example-3">
            #datasets-example-3 {
                display: flex;
                flex-wrap: wrap;
                flex-direction: row-reverse;
                align-items: center;
                gap: 20px;
                /* max-width: 1200px; */
                margin: 0 auto;
            }

            #datasets-example-3 .column {

                height: 250px;
                max-width: 800px;
            }

            #datasets-example-3 .legend {
                flex-shrink: 3;
            }

            .charts-css.legend li:nth-child(1)::before {
                background: #8bdd7c;
            }

            .charts-css.legend li:nth-child(2)::before {
                background: #ffe583;
            }

            .charts-css.legend li:nth-child(3)::before {
                background: #ffc765;
            }

            .charts-css.legend li:nth-child(4)::before {
                background: #5f5e5e;
            }
        </style>

        <div id="datasets-example-3">
            @isset($evaluations)
                @foreach ($evaluations as $evaluation)
                    @if ($evaluation->type == 0)
                        <h2 style="margin-top:10px; text-align: right; width:100%">{{ $evaluation->name }}</h2>
                        <table style="width: 100%"
                            class="charts-css column multiple show-labels data-spacing-1 datasets-spacing-1">

                            <tbody style="width:80%">

                                @foreach ($evaluation->values as $value)
                                    <tr style="margin-right: 20px">
                                        <th scope="row" style="margin-bottom: -20px;"> {{ $value->name }} </th>
                                        <td
                                            style="--size:@if ($value->excellent == 0) 0.05 @else{{ $value->excellent / 100 }} @endif; --color: #8bdd7c;">
                                            <span class="data"> {{ round($value->excellent) }} % </span>
                                        </td>
                                        <td
                                            style="--size:@if ($value->very_good == 0) 0.05 @else{{ $value->very_good / 100 }} @endif;--color: #ffe583;">
                                            <span class="data"> {{ round($value->very_good) }} % </span>
                                        </td>
                                        <td
                                            style="--size:@if ($value->good == 0) 0.05 @else {{ $value->good / 100 }} @endif;--color:#ffc765;">
                                            <span class="data">{{ round($value->good) }} % </span>
                                        </td>
                                        <td
                                            style="--size:@if ($value->week == 0) 0.05 @else {{ $value->week / 100 }} @endif; --color:#5f5e5e;">
                                            <span class="data"> {{ round($value->week) }} % </span>
                                        </td>

                                    </tr>
                                @endforeach
                                <ul class="charts-css legend legend-inline   legend-square" style="width:10%; border:0px">
                                    <li> ممتاز </li>
                                    <li> جيدجدا </li>
                                    <li> جيد </li>
                                    <li> مقبول </li>

                                </ul>
                            </tbody>
                        </table>
                    @endif
                @endforeach
            @endisset
        </div>

        <!--**********************************
                        Content body end
            ***********************************-->
    @endsection
    @section('script')
    @endsection
